<?php get_header(); ?>
/**
 * Custom header for Take5Nutrition child theme
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<header>
  <div class="header-inner">
    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="logo" aria-label="Home">
      <img src="https://take5nutrition.com/wp-content/uploads/2024/12/cropped-cropped-IMG_0815.png" alt="Take 5 Nutrition Logo" />
    </a>
    <div class="dropdown" id="dropdown">
      <button class="menu-btn" aria-haspopup="true" aria-expanded="false" aria-controls="menu-list" id="menu-btn" aria-label="Toggle menu">
        <span></span>
        <span></span>
        <span></span>
      </button>
      <nav class="dropdown-content" id="menu-list" role="menu" aria-labelledby="menu-btn">
        <a href="https://take5nutrition.com/what-i-offer/" role="menuitem">Booking</a>
        <a href="https://take5nutrition.com/about/" role="menuitem">About Me</a>
        <a href="https://take5nutrition.com/books/" role="menuitem">Blog</a>
      </nav>
    </div>
  </div>
</header>




