document.addEventListener('DOMContentLoaded', function() {
  const dropdown = document.getElementById('dropdown');
  const menuBtn = document.getElementById('menu-btn');

  menuBtn.addEventListener('click', (e) => {
    e.stopPropagation();
    const isExpanded = menuBtn.getAttribute('aria-expanded') === 'true';
    menuBtn.setAttribute('aria-expanded', String(!isExpanded));
    dropdown.classList.toggle('show');
  });

  document.addEventListener('click', (e) => {
    if (!dropdown.contains(e.target)) {
      dropdown.classList.remove('show');
      menuBtn.setAttribute('aria-expanded', 'false');
    }
  });
});
